import { defineStore } from "pinia";
import type { SendMail } from "~/interface/send_mail.interface";

export const useContactStore = defineStore('contact', () => {


    const sendMail = async (mail: SendMail) => {
        try {

            const response = await fetch('/api/sendMail', {
                method: 'POST',
                headers: {
                    "Content-type": "application/json",
                },
                body: JSON.stringify(mail)
            })

            const data = await response.json();

            if(data) {
                return true;
            } else {
                return false;
            }

        } catch (error) {
            console.error(error, ' erorr');   
            return false;
        }
    }

    return {
        sendMail,
    };
})